import React, { Component } from 'react';

import cn from 'client/utils/cn';
import Card from 'client/components/card';
import Link from 'client/components/link';
import Title from 'client/components/title';

import './index.css';

const b = cn('section-main-services');

interface Props {
    services: MainServices;
}

export default class SectionMainServices extends Component<Props> {
    render(): React.ReactNode {
        const { services } = this.props;

        return (
            <Card theme="light-grey">
                <div className={b()}>
                    <div className={b('content')}>
                        <div className={b('title')}>
                            <Title h3={services.title} />
                        </div>

                        <p className={b('text')}>{services.text}</p>

                        <Link
                            text={services.link.text}
                            href={services.link.url}
                            target="_blank"
                            icon="outside"
                        />
                    </div>
                </div>
            </Card>
        );
    }
}
