import React, { Component } from 'react';

import Slider2 from 'client/components/slider2';
import cn from 'client/utils/cn';
import Title from 'client/components/title';

import './index.css';
import './slides.css';

const b = cn('section-main');

const SLIDE_COUNT = 3;
const slideClassnames = Array.from(Array(SLIDE_COUNT).keys()).map((value) =>
    b('background-slide', { [value + 1]: true })
);

interface Props {
    title: string;
    text: string;
}

export default class SectionMain extends Component<Props> {
    render(): React.ReactNode {
        const { title, text } = this.props;

        return (
            <div className={b()}>
                <div className={b('slider')} aria-hidden="true">
                    <Slider2 classes={slideClassnames} />
                </div>

                <div className={b('content')}>
                    <Title h1={title} />

                    {text && (
                        <div
                            className={b('text')}
                            dangerouslySetInnerHTML={{ __html: text }}
                        />
                    )}
                </div>
            </div>
        );
    }
}
