import React, { Component } from 'react';

import cn from 'client/utils/cn';
import Title from 'client/components/title';
import Card from 'client/components/card';
import HintIcon from 'client/components/hint-icon';

import './index.css';

const b = cn('security-standarts');

interface Props {
    standarts: BunkerPageSecurity['sections']['standarts'];
}

export default class SecurityStandarts extends Component<Props> {
    renderItem = (item: StandartsItem, i: number): React.ReactNode => {
        return (
            <li className={b('item')} key={`item-${i}`}>
                <Card theme="light-grey" location="inner">
                    <Title h3={item.title} />

                    {item.tooltip && (
                        <div className={b('hint-icon')}>
                            <HintIcon
                                hint={item.tooltip}
                                mixClassName={b('hint')}
                                width={288}
                            />
                        </div>
                    )}
                </Card>
            </li>
        );
    };

    render(): React.ReactNode {
        const { standarts } = this.props;

        return (
            <Card theme="white">
                <div className={b()}>
                    <div className={b('title')}>
                        <Title h2={standarts.title} />
                    </div>

                    <ul className={b('items')}>
                        {standarts.items.map(this.renderItem)}
                    </ul>
                </div>
            </Card>
        );
    }
}
