import React, { Component } from 'react';
import { Helmet } from 'react-helmet';

import ellipsis from 'client/utils/ellipsis';
import LangContext from 'client/utils/lang-context';

interface Props {
    seo: SeoData;
    dontUseSuffix?: boolean;
}

export default class Seo extends Component<Props> {
    static contextType = LangContext;

    render(): React.ReactNode {
        const {
            seo: { title, description },
            dontUseSuffix
        } = this.props;
        const { dictionary } = this.context;
        let fullTitle = title;

        if (!dontUseSuffix) {
            const titleParts = [dictionary.sustainability, dictionary.yandex];

            titleParts.unshift(title);

            fullTitle = titleParts.join(' | ');
        }

        const fullDescription = ellipsis(description, 300);

        return (
            <Helmet>
                <title>{fullTitle}</title>

                <meta name="title" content={fullTitle} />
                <meta name="og:title" content={fullTitle} />
                <meta name="twitter:title" content={fullTitle} />

                <meta name="description" content={fullDescription} />
                <meta property="og:description" content={fullDescription} />
                <meta
                    property="twitter:description"
                    content={fullDescription}
                />
            </Helmet>
        );
    }
}
