import React, { Component } from 'react';
import Slider from 'react-slick';
import 'slick-carousel/slick/slick.css';

import cn from 'client/utils/cn';

import './index.css';

const SETTINGS = {
    accessibility: false,
    autoplaySpeed: 6 * 1000,
    autoplay: true,
    dots: false,
    infinite: true,
    easing: 'ease-in-out',
    speed: 600,
    slidesToShow: 1,
    slidesToScroll: 1,
    arrows: false
};

const b = cn('slider2');

interface Props {
    classes: string[];
}

class Slider2 extends Component<Props> {
    render(): React.ReactNode {
        const { classes } = this.props;

        return (
            <Slider {...SETTINGS} className={b()}>
                {classes.map((className) => (
                    <div key={className} className={b('image-item')}>
                        <div className={b('image', [className])} />
                    </div>
                ))}
            </Slider>
        );
    }
}

export default Slider2;
