import React, { Component } from 'react';

import cn from 'client/utils/cn';
import Icon from 'client/components/icon';
import Link from 'client/components/link';

import './index.css';

const b = cn('title');

interface Props {
    h1?: string;
    h2?: string;
    h3?: string;
    h4?: string;
    url?: string;
    icon?: 'helping-hand' | 'practicum' | undefined;
}

export default class Title extends Component<Props> {
    render(): React.ReactNode {
        const { h1, h2, h3, h4, url, icon } = this.props;

        return (
            <>
                {h1 &&
                    (url ? (
                        <h1 className={b('h1')}>
                            <Link href={url} target="_blank" icon="outside">
                                <span
                                    className={b('text')}
                                    dangerouslySetInnerHTML={{ __html: h1 }}
                                />
                            </Link>
                        </h1>
                    ) : (
                        <h1
                            className={b('h1')}
                            dangerouslySetInnerHTML={{ __html: h1 }}
                        />
                    ))}

                {h2 &&
                    (url ? (
                        <h2 className={b('h2')}>
                            <Link href={url} target="_blank" icon="outside">
                                <Icon type={icon} size="32" />

                                <span
                                    className={b('text')}
                                    dangerouslySetInnerHTML={{ __html: h2 }}
                                />
                            </Link>
                        </h2>
                    ) : (
                        <h2 className={b('h2')}>
                            <Icon type={icon} size="32" />

                            <span
                                className={b('text')}
                                dangerouslySetInnerHTML={{ __html: h2 }}
                            />
                        </h2>
                    ))}

                {h3 &&
                    (url ? (
                        <h3 className={b('h3')}>
                            <Link href={url} target="_blank" icon="outside">
                                <span
                                    className={b('text')}
                                    dangerouslySetInnerHTML={{ __html: h3 }}
                                />
                            </Link>
                        </h3>
                    ) : (
                        <h3
                            className={b('h3')}
                            dangerouslySetInnerHTML={{ __html: h3 }}
                        />
                    ))}

                {h4 &&
                    (url ? (
                        <h4 className={b('h4')}>
                            <Link href={url} target="_blank" icon="outside">
                                <span
                                    className={b('text')}
                                    dangerouslySetInnerHTML={{ __html: h4 }}
                                />
                            </Link>
                        </h4>
                    ) : (
                        <h4
                            className={b('h4')}
                            dangerouslySetInnerHTML={{ __html: h4 }}
                        />
                    ))}
            </>
        );
    }
}
