import React, { Component } from 'react';

import cn from 'client/utils/cn';

import './index.css';

const b = cn('tumbler');

interface Props {
    text?: string;
    onChange: (checked: boolean) => void;
}

interface State {
    isTumblerChecked: boolean;
}

export default class Tumbler extends Component<Props, State> {
    constructor(props: Props) {
        super(props);

        this.state = {
            isTumblerChecked: false
        };
    }

    toggleTumbler = (): void => {
        const { isTumblerChecked } = this.state;
        const { onChange } = this.props;
        const changeState = !isTumblerChecked;

        this.setState({ isTumblerChecked: changeState });
        onChange(changeState);
    };

    render(): React.ReactNode {
        const { text } = this.props;
        const { isTumblerChecked } = this.state;

        return (
            <div className={b()}>
                <button
                    aria-pressed={isTumblerChecked}
                    aria-label={text}
                    onClick={this.toggleTumbler}
                    className={b('button')}
                    type="button"
                />

                <label
                    aria-hidden="true"
                    htmlFor="change-image"
                    id="label-change-image"
                    onClick={this.toggleTumbler}
                    className={b('label')}
                >
                    {text}
                </label>

                <input
                    type="checkbox"
                    id="change-image"
                    className={b('control')}
                    hidden
                    value={isTumblerChecked}
                    autoComplete="off"
                />
            </div>
        );
    }
}
