import React, { Component } from 'react';

import cn from 'client/utils/cn';

import './index.css';

const b = cn('webcast');

interface Props {
    title: string;
    link: string;
}

export default class Webcast extends Component<Props> {
    render(): React.ReactNode {
        const { link, title } = this.props;

        // Doc: https://a.yandex-team.ru/svn/trunk/arcadia/frontend/projects/fiji/contribs/video-player/VH.md
        const params =
            '?from=partner&mute=1&autoplay=0&tv=0&no_ad=false&loop=false&play_on_visible=false&branding=0';
        const additionalParams =
            '&recommendations=off&report=0&hidden=externalPlayback';

        return (
            <div className={b()}>
                <iframe
                    title={title}
                    src={`${link}${params}${additionalParams}`}
                    className={b('iframe')}
                    width="600"
                    height="340"
                    scrolling="no"
                    allowFullScreen
                    allow="autoplay; fullscreen; accelerometer; gyroscope; picture-in-picture; encrypted-media"
                />
            </div>
        );
    }
}
