import React, { Component } from 'react';

import cn from 'client/utils/cn';
import SectionCardTabs from 'client/components/section-card-tabs';
import Title from 'client/components/title';

import './index.css';

const b = cn('wellbeing-item');

interface Props {
    title: string;
    items: CardTabsItem[];
}

export default class WellbeingItem extends Component<Props> {
    render(): React.ReactNode {
        const { items, title } = this.props;

        return (
            <div className={b()}>
                <div className={b('title')}>
                    <Title h3={title} />
                </div>

                <SectionCardTabs items={items} theme="light-grey" />
            </div>
        );
    }
}
