import React, { Component } from 'react';

import Docs from 'client/components/docs';
import { Page, PageSection } from 'client/components/page';
import Seo from 'client/components/seo';
import SectionGridColumn from 'client/components/section-grid-column';

interface Props {
    data: BunkerPageAccessible & { seo: SeoData };
}

export default class AccessiblePage extends Component<Props> {
    render(): React.ReactNode {
        const {
            data: {
                category,
                title,
                description,
                seo,
                menu,
                sections: { hand, dyk, docs }
            }
        } = this.props;

        return (
            <>
                <Seo seo={seo} />

                <Page menu={menu}>
                    <PageSection
                        theme="light-grey"
                        breadcrumb={category}
                        h1={title}
                        text={description}
                        offsetTop
                        offsetBottom
                    />

                    <PageSection
                        theme="light-grey"
                        h2={hand.title}
                        icon="helping-hand"
                        text={hand.description}
                        id={hand.id}
                        offsetBottom
                    >
                        <SectionGridColumn
                            theme="white"
                            icon="hands"
                            left={hand.items.left}
                            right={hand.items.right}
                        />
                    </PageSection>

                    <PageSection
                        theme="white"
                        h2={dyk.title}
                        text={dyk.description}
                        id={dyk.id}
                        offsetTop
                        offsetBottom
                    />

                    {docs.items.length > 0 && (
                        <PageSection
                            theme="black"
                            h2={docs.title}
                            id={docs.id}
                            offsetTop
                            offsetBottom
                        >
                            <Docs items={docs.items} theme="grey" />
                        </PageSection>
                    )}
                </Page>
            </>
        );
    }
}
