import React, { Component } from 'react';

import SectionAgendaStream from 'client/components/section-agenda-stream';
import { Page, PageSection } from 'client/components/page';
import Accordion from 'client/components/accordion';
import Seo from 'client/components/seo';

interface Props {
    data: BunkerPageAgenda & { seo: SeoData };
}

export default class AgendaPage extends Component<Props> {
    render(): React.ReactNode {
        const {
            data: { title, description, summary, streams, menu, seo }
        } = this.props;

        return (
            <>
                <Seo seo={seo} />

                <Page menu={menu}>
                    <PageSection
                        theme="white"
                        h1={title}
                        text={description}
                        offsetTop
                        offsetBottom
                    />

                    {streams.items.map(
                        (item: StreamItem, i): React.ReactNode => (
                            <PageSection
                                theme="light-grey"
                                h2={item.title}
                                id={item.id}
                                offsetTop
                                offsetBottom={i === streams.items.length - 1}
                                key={`page-section-${i}`}
                            >
                                <SectionAgendaStream
                                    item={item}
                                    dictionary={streams.dictionary}
                                    contributions={streams.contributions}
                                />
                            </PageSection>
                        )
                    )}

                    <PageSection
                        theme="white"
                        h2={summary.title}
                        text={summary.description}
                        offsetTop
                        offsetBottom
                    >
                        <Accordion items={summary.items} theme="light-grey" />
                    </PageSection>
                </Page>
            </>
        );
    }
}
