import React, { Component } from 'react';

import Docs from 'client/components/docs';
import { Page, PageSection } from 'client/components/page';
import Seo from 'client/components/seo';
import SectionCardTabs from 'client/components/section-card-tabs';

interface Props {
    data: BunkerPageAnticorruption & { seo: SeoData };
}

export default class AnticorruptionPage extends Component<Props> {
    render(): React.ReactNode {
        const {
            data: {
                category,
                title,
                description,
                seo,
                menu,
                sections: { statement, docs }
            }
        } = this.props;

        return (
            <>
                <Seo seo={seo} />

                <Page menu={menu}>
                    <PageSection
                        theme="light-grey"
                        breadcrumb={category}
                        h1={title}
                        text={description}
                        offsetTop
                        offsetBottom
                    />

                    <PageSection
                        theme="light-grey"
                        h2={statement.title}
                        id={statement.id}
                        offsetBottom
                    >
                        <SectionCardTabs
                            items={statement.items}
                            theme="white"
                        />
                    </PageSection>

                    {docs.items.length > 0 && (
                        <PageSection
                            theme="black"
                            h2={docs.title}
                            id={docs.id}
                            offsetTop
                            offsetBottom
                        >
                            <Docs items={docs.items} theme="grey" />
                        </PageSection>
                    )}
                </Page>
            </>
        );
    }
}
