import React, { Component } from 'react';

import { Page, PageSection } from 'client/components/page';
import Chart from 'client/components/chart';
import LangContext from 'client/utils/lang-context';
import SectionCardTabs from 'client/components/section-card-tabs';
import Seo from 'client/components/seo';

interface Props {
    data: BunkerPageCarbon & { seo: SeoData };
}

export default class CarbonPage extends Component<Props> {
    static contextType = LangContext;

    render(): React.ReactNode {
        const {
            data: {
                category,
                title,
                description,
                seo,
                menu,
                sections: { ghg, decarbonizing, empowering }
            }
        } = this.props;

        const { dictionary } = this.context;

        return (
            <>
                <Seo seo={seo} />

                <Page menu={menu}>
                    <PageSection
                        theme="light-grey"
                        breadcrumb={category}
                        h1={title}
                        text={description}
                        offsetTop
                        offsetBottom
                    />

                    <PageSection
                        theme="light-grey"
                        h2={ghg.title}
                        id={ghg.id}
                        offsetBottom
                    >
                        <Chart data={ghg.chart} />
                    </PageSection>

                    <PageSection
                        theme="light-grey"
                        h2={decarbonizing.title}
                        id={decarbonizing.id}
                        text={decarbonizing.description}
                        offsetBottom
                    />

                    <PageSection
                        theme="white"
                        h2={empowering.title}
                        id={empowering.id}
                        text={empowering.description}
                        offsetTop
                        offsetBottom
                    >
                        <SectionCardTabs
                            items={empowering.items}
                            cardLinkText={dictionary.explore}
                            theme="light-grey"
                        />
                    </PageSection>
                </Page>
            </>
        );
    }
}
