import React, { Component } from 'react';

import CardFact from 'client/components/card-fact';
import { Page, PageSection } from 'client/components/page';
import Docs from 'client/components/docs';
import Seo from 'client/components/seo';
import SectionCardTabs from 'client/components/section-card-tabs';
import SectionGridRow from 'client/components/section-grid-row';

interface Props {
    data: BunkerPageConvenience & { seo: SeoData };
}

export default class ConveniencePage extends Component<Props> {
    render(): React.ReactNode {
        const {
            data: {
                category,
                title,
                description,
                seo,
                menu,
                sections: { facts, support, docs }
            }
        } = this.props;

        return (
            <>
                <Seo seo={seo} />

                <Page menu={menu}>
                    <PageSection
                        theme="light-grey"
                        breadcrumb={category}
                        h1={title}
                        text={description}
                        offsetTop
                        offsetBottom
                    />

                    <PageSection
                        theme="light-grey"
                        h2={facts.title}
                        id={facts.id}
                        offsetBottom
                    >
                        <SectionGridRow ratios="33-66">
                            {facts.items.map((item, index) => (
                                <CardFact
                                    theme="white"
                                    key={`facts-card-${index}`}
                                    icon={item.icon}
                                    iconSize="32"
                                    location="inner"
                                    title={item.title}
                                    text={item.text}
                                    stretched
                                />
                            ))}
                        </SectionGridRow>
                    </PageSection>

                    <PageSection
                        theme="white"
                        h2={support.title}
                        id={support.id}
                        text={support.description}
                        offsetTop
                        offsetBottom
                    >
                        <SectionCardTabs
                            items={support.items}
                            theme="light-grey"
                        />
                    </PageSection>

                    {docs.items.length > 0 && (
                        <PageSection
                            theme="black"
                            h2={docs.title}
                            id={docs.id}
                            offsetTop
                            offsetBottom
                        >
                            <Docs items={docs.items} theme="grey" />
                        </PageSection>
                    )}
                </Page>
            </>
        );
    }
}
