import React, { Component } from 'react';

import { Page, PageSection } from 'client/components/page';
import Seo from 'client/components/seo';

import Webcast from '../components/webcast';

interface Props {
    data: BunkerPageDownloadWebcast & { seo: SeoData };
}

export default class DownloadWebcastPage extends Component<Props> {
    render(): React.ReactNode {
        const {
            data: { title, link, seo }
        } = this.props;

        return (
            <>
                <Seo seo={seo} />

                <Page>
                    <PageSection theme="light-grey" h1={title} offsetTop />

                    <PageSection theme="light-grey" offsetTop offsetBottom>
                        <Webcast link={link} title={title} />
                    </PageSection>
                </Page>
            </>
        );
    }
}
