import React, { Component } from 'react';

import { Page, PageSection } from 'client/components/page';
import DownloadYears from 'client/components/download-years';
import Seo from 'client/components/seo';

interface Props {
    data: BunkerPageDownload & { seo: SeoData };
}

export default class DownloadPage extends Component<Props> {
    render(): React.ReactNode {
        const {
            data: { title, years, seo }
        } = this.props;

        return (
            <>
                <Seo seo={seo} />

                <Page>
                    <PageSection
                        theme="light-grey"
                        h1={title}
                        offsetTop
                        offsetBottom
                    >
                        <DownloadYears years={years} />
                    </PageSection>
                </Page>
            </>
        );
    }
}
