import React, { Component } from 'react';

import { Page, PageSection } from 'client/components/page';
import Practicum from 'client/components/practicum';
import SectionEducationAreas from 'client/components/section-education-areas';
import SectionEducationInitiatives from 'client/components/section-education-initiatives';
import Seo from 'client/components/seo';

interface Props {
    data: BunkerPageEducation & { seo: SeoData };
}

export default class EducationPage extends Component<Props> {
    render(): React.ReactNode {
        const {
            data: {
                category,
                title,
                description,
                menu,
                sections: { initiatives, areas, practicum },
                seo
            }
        } = this.props;

        return (
            <>
                <Seo seo={seo} />

                <Page menu={menu}>
                    <PageSection
                        theme="light-grey"
                        breadcrumb={category}
                        h1={title}
                        text={description}
                        offsetTop
                        offsetBottom
                    />

                    <PageSection
                        theme="light-grey"
                        h2={initiatives.title}
                        id={initiatives.id}
                        offsetBottom
                    >
                        <SectionEducationInitiatives
                            initiatives={initiatives}
                        />
                    </PageSection>

                    <PageSection
                        theme="white"
                        h2={areas.title}
                        id={areas.id}
                        offsetTop
                        offsetBottom
                    >
                        {areas.items.map(
                            (item, index): React.ReactNode => (
                                <SectionEducationAreas
                                    key={index}
                                    item={item}
                                />
                            )
                        )}
                    </PageSection>

                    <PageSection
                        theme="light-grey"
                        h2={practicum.title}
                        id={practicum.id}
                        icon="practicum"
                        text={practicum.description}
                        offsetTop
                        offsetBottom
                    >
                        <Practicum data={practicum.data} />
                    </PageSection>
                </Page>
            </>
        );
    }
}
