import React, { Component } from 'react';

import { Page, PageSection } from 'client/components/page';
import CardDigit from 'client/components/card-digit';
import Chart from 'client/components/chart';
import DevelopingLeaders from 'client/components/developing-leaders';
import EmployeeEngagement from 'client/components/employee-engagement';
import SectionGridColumn from 'client/components/section-grid-column';
import Seo from 'client/components/seo';
import RowFactImage from 'client/components/row-fact-image';
import WellbeingItem from 'client/components/wellbeing-item';

interface Props {
    data: BunkerPageEmployees & { seo: SeoData };
}

export default class EducationPage extends Component<Props> {
    render(): React.ReactNode {
        const {
            data: {
                category,
                title,
                description,
                seo,
                menu,
                sections: { workforce, diversity, developing, wellbeing }
            }
        } = this.props;

        return (
            <>
                <Seo seo={seo} />

                <Page menu={menu}>
                    <PageSection
                        theme="light-grey"
                        breadcrumb={category}
                        h1={title}
                        text={description}
                        offsetTop
                        offsetBottom
                    />

                    <PageSection
                        theme="light-grey"
                        h2={workforce.title}
                        id={workforce.id}
                        offsetBottom
                    >
                        <Chart data={workforce.team} />

                        <Chart data={workforce.women} />

                        <RowFactImage
                            theme="white"
                            ratios="33-66"
                            image={workforce.fact.image}
                        >
                            <EmployeeEngagement
                                engagement={workforce.fact.engagement}
                            />
                        </RowFactImage>
                    </PageSection>

                    <PageSection
                        theme="grey"
                        h2={diversity.title}
                        id={diversity.id}
                        text={diversity.description}
                        offsetTop
                        offsetBottom
                    >
                        <SectionGridColumn
                            theme="white"
                            icon="handshake"
                            left={diversity.items.left}
                            right={diversity.items.right}
                        />
                    </PageSection>

                    <PageSection
                        theme="grey"
                        h2={developing.title}
                        id={developing.id}
                        text={developing.description}
                        offsetBottom
                    >
                        <DevelopingLeaders items={developing.items} />
                    </PageSection>

                    <PageSection
                        theme="white"
                        h2={wellbeing.title}
                        id={wellbeing.id}
                        text={wellbeing.description}
                        offsetTop
                        offsetBottom
                    >
                        <WellbeingItem
                            title={wellbeing.finances.title}
                            items={wellbeing.finances.items}
                        />

                        <WellbeingItem
                            title={wellbeing.comfort.title}
                            items={wellbeing.comfort.items}
                        />

                        <RowFactImage
                            theme="light-grey"
                            ratios="66-33"
                            image={wellbeing.comfort.fact.image}
                        >
                            <CardDigit
                                theme="light-grey"
                                data={wellbeing.comfort.fact.digit}
                            />
                        </RowFactImage>
                    </PageSection>
                </Page>
            </>
        );
    }
}
