import React, { Component } from 'react';

import { Page, PageSection } from 'client/components/page';
import CardDigit from 'client/components/card-digit';
import Chart from 'client/components/chart';
import RowFactImage from 'client/components/row-fact-image';
import Seo from 'client/components/seo';
import SectionDatacenters from 'client/components/section-datacenters';
import SectionGridColumn from 'client/components/section-grid-column';

interface Props {
    data: BunkerPageEnergy & { seo: SeoData };
}

export default class EnergyPage extends Component<Props> {
    render(): React.ReactNode {
        const {
            data: {
                category,
                title,
                description,
                seo,
                menu,
                sections: { consumption, efficiency, datacenters }
            }
        } = this.props;

        return (
            <>
                <Seo seo={seo} />

                <Page menu={menu}>
                    <PageSection
                        theme="light-grey"
                        breadcrumb={category}
                        h1={title}
                        text={description}
                        offsetTop
                        offsetBottom
                    />

                    <PageSection
                        theme="light-grey"
                        h2={consumption.title}
                        id={consumption.id}
                        offsetBottom
                    >
                        <Chart data={consumption.electricity} />

                        <Chart data={consumption.pue} />

                        <RowFactImage
                            theme="white"
                            ratios="33-66"
                            image={consumption.fact.image}
                        >
                            <CardDigit
                                theme="white"
                                data={consumption.fact.digit}
                            />
                        </RowFactImage>
                    </PageSection>

                    <PageSection
                        theme="white"
                        h2={datacenters.title}
                        id={datacenters.id}
                        offsetTop
                    >
                        <SectionDatacenters datacenters={datacenters} />
                    </PageSection>

                    <PageSection
                        theme="white"
                        h2={efficiency.title}
                        id={efficiency.id}
                        offsetTop
                        offsetBottom
                    >
                        <SectionGridColumn
                            theme="light-grey"
                            icon="leaves"
                            left={efficiency.items.left}
                            right={efficiency.items.right}
                        />
                    </PageSection>
                </Page>
            </>
        );
    }
}
