import React, { Component } from 'react';

import { Page, PageSection } from 'client/components/page';
import Accordion from 'client/components/accordion';
import Seo from 'client/components/seo';

interface Props {
    data: BunkerPageFaq & { seo: SeoData };
}

export default class FaqPage extends Component<Props> {
    render(): React.ReactNode {
        const {
            data: {
                title,
                menu,
                seo,
                themes: { items }
            }
        } = this.props;

        return (
            <>
                <Seo seo={seo} />

                <Page menu={menu}>
                    <PageSection theme="white" h1={title} offsetTop />

                    {items.map(
                        (item: any, i: number): React.ReactNode => (
                            <PageSection
                                theme="white"
                                h2={item.title}
                                id={item.id}
                                offsetTop
                                key={`page-section-${i}`}
                                offsetBottom={i === items.length - 1}
                            >
                                <Accordion
                                    items={item.topics}
                                    theme="light-grey"
                                />
                            </PageSection>
                        )
                    )}
                </Page>
            </>
        );
    }
}
