import React, { Component } from 'react';

import { Page, PageSection } from 'client/components/page';
import SectionMain from 'client/components/section-main';
import SectionMainResult from 'client/components/section-main-result';
import SectionMainServices from 'client/components/section-main-services';
import Seo from 'client/components/seo';

interface Props {
    data: BunkerPageMain & { seo: SeoData };
}

export default class MainPage extends Component<Props> {
    render(): React.ReactNode {
        const {
            data: { title, description, seo, results, techs, governs }
        } = this.props;

        return (
            <>
                <Seo seo={seo} dontUseSuffix />

                <Page>
                    <SectionMain title={title} text={description} />

                    <PageSection
                        isMainPage
                        theme="light-grey"
                        offsetTop
                        offsetBottom
                    >
                        <SectionMainResult results={results} />
                    </PageSection>

                    <PageSection
                        isMainPage
                        theme="white"
                        h2={techs.title}
                        offsetTop
                    >
                        <SectionMainServices services={techs.services} />
                    </PageSection>

                    <PageSection
                        isMainPage
                        theme="white"
                        h2={governs.title}
                        text={governs.description}
                        offsetTop
                        offsetBottom
                    />
                </Page>
            </>
        );
    }
}
