import React, { Component } from 'react';

import { Page, PageSection } from 'client/components/page';

interface Props {
    data: BunkerPageNotFound;
}

export default class NotFoundPage extends Component<Props> {
    render(): React.ReactNode {
        const { data } = this.props;

        return (
            <Page>
                <PageSection
                    theme="white"
                    h1={data.title}
                    text={data.text}
                    offsetTop
                    offsetBottom
                />
            </Page>
        );
    }
}
