import React, { Component } from 'react';

import { Page, PageSection } from 'client/components/page';
import Seo from 'client/components/seo';
import Docs from 'client/components/docs';
import PartnersList from 'client/components/partners-list';
import Principles from 'client/components/principles';
import SectionGridColumn from 'client/components/section-grid-column';
import SectionCardTabs from 'client/components/section-card-tabs';

interface Props {
    data: BunkerPagePartners & { seo: SeoData };
}

export default class PartnersPage extends Component<Props> {
    render(): React.ReactNode {
        const {
            data: {
                category,
                title,
                description,
                seo,
                menu,
                sections: { docs, partners, principles, benefits, safety }
            }
        } = this.props;

        return (
            <>
                <Seo seo={seo} />

                <Page menu={menu}>
                    <PageSection
                        theme="light-grey"
                        breadcrumb={category}
                        h1={title}
                        text={description}
                        offsetTop
                        offsetBottom
                    >
                        <PartnersList partners={partners} />
                    </PageSection>

                    <PageSection
                        theme="white"
                        h2={principles.title}
                        id={principles.id}
                        offsetTop
                    >
                        <Principles items={principles.items} />
                    </PageSection>

                    <PageSection
                        theme="white"
                        h2={benefits.title}
                        id={benefits.id}
                        offsetTop
                    >
                        <SectionCardTabs
                            items={benefits.items}
                            theme="light-grey"
                        />
                    </PageSection>

                    <PageSection
                        theme="white"
                        h2={safety.title}
                        id={safety.id}
                        offsetTop
                        offsetBottom
                    >
                        <SectionGridColumn
                            theme="light-grey"
                            icon="handshake"
                            left={safety.items.left}
                            right={safety.items.right}
                        />
                    </PageSection>

                    {docs.items.length > 0 && (
                        <PageSection
                            theme="black"
                            h2={docs.title}
                            id={docs.id}
                            offsetTop
                            offsetBottom
                        >
                            <Docs items={docs.items} theme="grey" />
                        </PageSection>
                    )}
                </Page>
            </>
        );
    }
}
