import React, { Component } from 'react';

import Docs from 'client/components/docs';
import CardFact from 'client/components/card-fact';
import { Page, PageSection } from 'client/components/page';
import Seo from 'client/components/seo';
import SectionGridRow from 'client/components/section-grid-row';

interface Props {
    data: BunkerPageProcurement & { seo: SeoData };
}

export default class ProcurementPage extends Component<Props> {
    render(): React.ReactNode {
        const {
            data: {
                category,
                title,
                description,
                seo,
                menu,
                sections: { facts, suppliers, docs }
            }
        } = this.props;

        return (
            <>
                <Seo seo={seo} />

                <Page menu={menu}>
                    <PageSection
                        theme="light-grey"
                        breadcrumb={category}
                        h1={title}
                        text={description}
                        offsetTop
                        offsetBottom
                    />

                    <PageSection
                        theme="light-grey"
                        h2={facts.title}
                        id={facts.id}
                        offsetBottom
                    >
                        <SectionGridRow>
                            {facts.items.map((item, index) => (
                                <CardFact
                                    theme="white"
                                    key={`facts-card-${index}`}
                                    location="inner"
                                    title={item.title}
                                    text={item.text}
                                    stretched
                                />
                            ))}
                        </SectionGridRow>
                    </PageSection>

                    <PageSection
                        theme="light-grey"
                        h2={suppliers.title}
                        id={suppliers.id}
                        offsetBottom
                    >
                        <SectionGridRow>
                            {suppliers.items.map((item, index) => (
                                <CardFact
                                    theme="white"
                                    key={`suppliers-card-${index}`}
                                    icon="handcart"
                                    iconSize="52"
                                    title={item.title}
                                    text={item.text}
                                    stretched
                                />
                            ))}
                        </SectionGridRow>
                    </PageSection>

                    {docs.items.length > 0 && (
                        <PageSection
                            theme="black"
                            h2={docs.title}
                            id={docs.id}
                            offsetTop
                            offsetBottom
                        >
                            <Docs items={docs.items} theme="grey" />
                        </PageSection>
                    )}
                </Page>
            </>
        );
    }
}
