import React, { Component } from 'react';

import Docs from 'client/components/docs';
import { Page, PageSection } from 'client/components/page';
import Seo from 'client/components/seo';
import SectionCardTabs from 'client/components/section-card-tabs';
import CardFact from 'client/components/card-fact';
import SectionGridRow from 'client/components/section-grid-row';

interface Props {
    data: BunkerPageQuality & { seo: SeoData };
}

export default class QualityPage extends Component<Props> {
    render(): React.ReactNode {
        const {
            data: {
                category,
                title,
                description,
                seo,
                menu,
                sections: { search, advertising, blogging, docs }
            }
        } = this.props;

        return (
            <>
                <Seo seo={seo} />

                <Page menu={menu}>
                    <PageSection
                        theme="light-grey"
                        breadcrumb={category}
                        h1={title}
                        text={description}
                        offsetTop
                        offsetBottom
                    />

                    <PageSection
                        theme="light-grey"
                        h2={search.title}
                        id={search.id}
                        text={search.description}
                        offsetBottom
                    >
                        <SectionCardTabs items={search.items} theme="white" />
                    </PageSection>

                    <PageSection
                        theme="light-grey"
                        h2={advertising.title}
                        id={advertising.id}
                        text={advertising.description}
                        offsetBottom
                    >
                        <SectionCardTabs
                            items={advertising.items}
                            theme="white"
                        />
                        <SectionGridRow>
                            {advertising.facts?.map((fact, index) => (
                                <CardFact
                                    theme="white"
                                    key={index}
                                    location="inner"
                                    title={fact.title}
                                    text={fact.text}
                                    stretched
                                />
                            ))}
                        </SectionGridRow>
                    </PageSection>

                    <PageSection
                        theme="light-grey"
                        h2={blogging.title}
                        id={blogging.id}
                        text={blogging.description}
                        offsetBottom
                    >
                        <SectionCardTabs items={blogging.items} theme="white" />
                    </PageSection>

                    {docs.items.length > 0 && (
                        <PageSection
                            theme="black"
                            h2={docs.title}
                            id={docs.id}
                            offsetTop
                            offsetBottom
                        >
                            <Docs items={docs.items} theme="grey" />
                        </PageSection>
                    )}
                </Page>
            </>
        );
    }
}
