import React, { Component } from 'react';

import Accordion from 'client/components/accordion';
import CardFact from 'client/components/card-fact';
import Docs from 'client/components/docs';
import ImageCard from 'client/components/image-card';
import { Page, PageSection } from 'client/components/page';
import LangContext from 'client/utils/lang-context';
import PrivacyOther from 'client/components/privacy-other';
import Seo from 'client/components/seo';
import SecurityStandarts from 'client/components/security-standarts';

interface Props {
    data: BunkerPageSecurity & { seo: SeoData };
}

export default class SecurityPage extends Component<Props> {
    static contextType = LangContext;

    render(): React.ReactNode {
        const {
            data: {
                category,
                title,
                description,
                menu,
                seo,
                sections: { standarts, privacy, bug, questions, docs }
            }
        } = this.props;

        return (
            <>
                <Seo seo={seo} />

                <Page menu={menu}>
                    <PageSection
                        theme="light-grey"
                        breadcrumb={category}
                        h1={title}
                        text={description}
                        offsetTop
                        offsetBottom
                    >
                        <SecurityStandarts standarts={standarts} />
                    </PageSection>

                    <PageSection
                        theme="white"
                        h2={privacy.title}
                        id={privacy.id}
                        text={privacy.description}
                        offsetTop
                        offsetBottom
                    >
                        <CardFact
                            theme="light-grey"
                            key="facts-card-privacy"
                            icon="shield"
                            iconSize="52"
                            title={privacy.tool.title}
                            popup={privacy.tool.popup}
                            text={privacy.tool.description}
                            stretched
                        >
                            {privacy.tool.image && (
                                <ImageCard
                                    src={privacy.tool.image}
                                    title={privacy.tool.title}
                                    hidden
                                />
                            )}
                        </CardFact>

                        <PrivacyOther other={privacy.other} />
                    </PageSection>

                    <PageSection
                        theme="light-grey"
                        h2={bug.title}
                        id={bug.id}
                        url={bug.url}
                        text={bug.description}
                        offsetTop
                        offsetBottom
                    />

                    <PageSection
                        theme="light-grey"
                        h2={questions.title}
                        id={questions.id}
                        url={questions.url}
                        text={questions.description}
                        offsetBottom
                    >
                        <Accordion items={questions.items} theme="white" />
                    </PageSection>

                    {docs.items.length > 0 && (
                        <PageSection
                            theme="black"
                            h2={docs.title}
                            id={docs.id}
                            offsetTop
                            offsetBottom
                        >
                            <Docs items={docs.items} theme="grey" />
                        </PageSection>
                    )}
                </Page>
            </>
        );
    }
}
