import React, { Component } from 'react';

import { Page, PageSection } from 'client/components/page';
import Seo from 'client/components/seo';
import Chart from 'client/components/chart';
import CardFact from 'client/components/card-fact';
import LangContext from 'client/utils/lang-context';
import SectionGridRow from 'client/components/section-grid-row';
import SectionCardTabs from 'client/components/section-card-tabs';

interface Props {
    data: BunkerPageWaste & { seo: SeoData };
}

export default class WastePage extends Component<Props> {
    static contextType = LangContext;

    render(): React.ReactNode {
        const {
            data: {
                category,
                title,
                description,
                seo,
                menu,
                sections: { packaging, approach, engaging, facts, keeping }
            }
        } = this.props;

        const { dictionary } = this.context;

        return (
            <>
                <Seo seo={seo} />

                <Page menu={menu}>
                    <PageSection
                        theme="light-grey"
                        breadcrumb={category}
                        h1={title}
                        text={description}
                        offsetTop
                        offsetBottom
                    />

                    <PageSection
                        theme="light-grey"
                        h2={packaging.title}
                        id={packaging.id}
                        offsetBottom
                    >
                        <Chart data={packaging.market} />
                    </PageSection>

                    <PageSection
                        theme="white"
                        h2={facts.title}
                        id={facts.id}
                        offsetTop
                        offsetBottom
                    >
                        <SectionGridRow>
                            {facts.items.map((item, index) => (
                                <CardFact
                                    theme="light-grey"
                                    key={`facts-card-${index}`}
                                    location="inner"
                                    title={item.title}
                                    text={item.text}
                                    stretched
                                />
                            ))}
                        </SectionGridRow>
                    </PageSection>

                    <PageSection
                        theme="grey"
                        h2={approach.title}
                        id={approach.id}
                        text={approach.description}
                        offsetTop
                        offsetBottom
                    >
                        <SectionGridRow>
                            {approach.items.map((item, index) => (
                                <CardFact
                                    theme="white"
                                    key={`facts-card-${index}`}
                                    location="inner"
                                    title={item.title}
                                    text={item.text}
                                    popup={item.popup}
                                    doc={item.doc}
                                    stretched
                                />
                            ))}
                        </SectionGridRow>
                    </PageSection>

                    <PageSection
                        theme="light-grey"
                        h2={engaging.title}
                        id={engaging.id}
                        offsetTop
                    >
                        <SectionCardTabs
                            items={engaging.items}
                            cardLinkText={dictionary.access}
                            theme="white"
                        />
                    </PageSection>

                    <PageSection
                        theme="light-grey"
                        h2={keeping.title}
                        id={keeping.id}
                        offsetTop
                        offsetBottom
                    >
                        <SectionCardTabs items={keeping.items} theme="white" />
                    </PageSection>
                </Page>
            </>
        );
    }
}
