import { join } from 'path';

import { AppConfig } from '@yandex-int/yandex-cfg';
import deployStream from '@yandex-int/yandex-logger/streams/deploy';

import defaultsCsp from './csp/defaults';

const config: AppConfig = {
    bunker: {
        api: 'http://bunker-api-ir.yandex.net/v1',
        cache: true,
        project: 'esg'
    },

    csp: {
        presets: defaultsCsp,
        policies: {},
        serviceName: 'esg',
        useDefaultReportUri: true
    },

    httpUatraits: {
        server: 'http://uatraits.qloud.yandex.ru',
        clientOptions: {
            timeout: 100
        }
    },

    i18n: {
        langs: ['en'],
        tldToLang: {
            com: 'en'
        }
    },

    logger: {
        fields: {
            environment: process.env.NODE_ENV
        },
        name: 'esg',
        streams: [
            {
                level: 'info',
                stream: deployStream()
            }
        ]
    },

    static: {
        dir: join(__dirname, '..', 'client'),
        staticDir: join(__dirname, '..', '..', 'static')
    },

    render: {
        isHot: false
    },

    tvm: {
        serverUrl: 'http://localhost:8001',
        destinations: ['blogsApi'],
        clientId: 'esg',
        token: process.env.TVMTOOL_LOCAL_AUTHTOKEN
    },

    metrikaCounterId: 87381155,

    metrikaOptions: {
        clickmap: true,
        trackLinks: true,
        webvisor: true,
        accurateTrackBounce: true
    }
};

module.exports = config;
