import { AppConfig } from '@yandex-int/yandex-cfg';
import lineStream from '@yandex-int/yandex-logger/streams/line';

import localCsp from './csp/local';

const config: AppConfig = {
    bunker: {
        version: 'latest'
    },

    csp: {
        presets: localCsp
    },

    httpUatraits: {
        server: 'http://uatraits-test.qloud.yandex.ru'
    },

    logger: {
        streams: [
            {
                level: 'info',
                stream: lineStream({
                    template: [
                        '{{date}}',
                        '{{levelName}}',
                        '{{msg}}',
                        '{{#err}}\n{{err.stack}}{{/err}}'
                    ].join(' ')
                })
            }
        ]
    },

    render: {
        isHot: true
    },

    static: {
        baseUrl: '/static',
        frozenPath: '/_',
        version: ''
    },

    tvm: {
        token: 'tvmtool-development-access-token'
    }
};

module.exports = config;
