import { AppConfig } from '@yandex-int/yandex-cfg';

import productionCsp from './csp/production';

// env.js генерится при в сандбоксе при сборке в CI и используется только в рантайме
// eslint-disable-next-line import/no-unresolved, global-require
const APP_VERSION = process.env.APP_VERSION || require('../env.js').APP_VERSION;

const config: AppConfig = {
    bunker: {
        updateInterval: 60000,
        version: 'stable'
    },

    csp: {
        presets: productionCsp
    },

    logger: {
        fields: {
            release: APP_VERSION
        }
    },

    static: {
        baseUrl: '//yastatic.net/s3/esg-static/static/',
        frozenPath: '_',
        version: APP_VERSION
    }
};

module.exports = config;
