import { Request, Response } from 'express';

import { getBunkerPageData } from 'server/utils/bunker-utils';
import { getCommonPageData } from 'server/utils/page-utils';
import { formatTextsToWiki } from 'server/utils/wiki-utils';

export default async function agendaController(
    req: Request,
    res: Response
): Promise<void> {
    const pageName = 'agenda';
    const { bunker, lang } = req;
    const pageData = getBunkerPageData(lang, bunker, pageName);
    const { streams, summary } = pageData.page;

    if (streams && streams.items) {
        pageData.page.menu = streams.items.map((stream: any) => {
            return {
                id: stream.id,
                titlenav: stream.title
            };
        });
    }

    const { items } = summary;
    if (items.length > 0) {
        pageData.page.summary.items = await formatTextsToWiki(items);
    }

    res.renderBundle('common', pageName, {
        ...getCommonPageData(req, res, pageName),
        ...pageData
    });
}
