import { NextFunction, Request, Response } from 'express';
import _ from 'lodash';

export function getBunkerDocData(
    lang: BunkerLang,
    bunker: Bunker,
    docPath: string
): PageData | undefined {
    const bunkerLangData = _.cloneDeep(_.get(bunker, lang));
    const pageData = _.get(bunkerLangData, `pages.${docPath}`);

    if (!pageData) {
        return undefined;
    }

    return {
        page: pageData
    };
}

export default function documentController(
    req: Request,
    res: Response,
    next: NextFunction
): void {
    const path = req.path.replace('/download-center/', '');
    const { bunker, lang } = req;

    const pageData = getBunkerDocData(lang, bunker, `download[${path}]`);
    if (!pageData || !pageData.page || !pageData.page.link) {
        next();

        return;
    }

    res.redirect(pageData.page.link);
}
