import { Request, Response } from 'express';

import { getBunkerPageData } from 'server/utils/bunker-utils';
import { getCommonPageData } from 'server/utils/page-utils';

export default function webcastController(req: Request, res: Response): void {
    const pageName = 'download[webcast]';
    const { bunker, lang } = req;
    const pageData = getBunkerPageData(lang, bunker, pageName);

    res.renderBundle('common', pageName, {
        ...getCommonPageData(req, res, pageName),
        ...pageData
    });
}
