import { NextFunction, Request, Response } from 'express';

import { getBunkerPageData } from 'server/utils/bunker-utils';
import {
    getCommonPageData,
    getMenu,
    getPreparedSections
} from 'server/utils/page-utils';
import getFormattedText, { formatTextsToWiki } from 'server/utils/wiki-utils';

export default async function carbonController(
    req: Request,
    res: Response,
    next: NextFunction
): Promise<void> {
    const pageSection = 'environmental-impact';
    const pageName = 'carbon';
    const { bunker, lang } = req;
    const pageData = getBunkerPageData(lang, bunker, pageName);
    const { page } = pageData;

    if (!page.sections) {
        next();

        return;
    }

    const sectionsPrepared = getPreparedSections(page.sections);

    page.sections = sectionsPrepared;
    page.menu = getMenu(sectionsPrepared);

    const { description } = (
        page.sections as unknown as BunkerPageCarbon['sections']
    ).decarbonizing;
    if (description) {
        page.sections.decarbonizing.description = await getFormattedText(
            description
        );
    }

    const { items } = (page.sections as unknown as BunkerPageCarbon['sections'])
        .empowering;
    if (items.length > 0) {
        page.sections.empowering.items = await formatTextsToWiki(items);
    }

    res.renderBundle('common', pageName, {
        ...getCommonPageData(req, res, pageName, pageSection),
        ...pageData
    });
}
