import { NextFunction, Request, Response } from 'express';

import { getBunkerPageData } from 'server/utils/bunker-utils';
import {
    getCommonPageData,
    getMenu,
    getPreparedSections
} from 'server/utils/page-utils';
import { formatTextsToWiki } from 'server/utils/wiki-utils';

export default async function energyController(
    req: Request,
    res: Response,
    next: NextFunction
): Promise<void> {
    const pageSection = 'environmental-impact';
    const pageName = 'energy';
    const { bunker, lang } = req;
    const pageData = getBunkerPageData(lang, bunker, pageName);
    const { page } = pageData;

    if (!page.sections) {
        next();

        return;
    }

    const sectionsPrepared = getPreparedSections(page.sections);

    page.sections = sectionsPrepared;
    page.menu = getMenu(sectionsPrepared);

    const efficiency = page.sections
        .efficiency as unknown as BunkerPageEnergy['sections']['efficiency'];
    const { right } = efficiency.items;
    if (right.length > 0) {
        efficiency.items.right = await formatTextsToWiki(right);
    }

    res.renderBundle('common', pageName, {
        ...getCommonPageData(req, res, pageName, pageSection),
        ...pageData
    });
}
