import { NextFunction, Request, Response } from 'express';

import { getBunkerPageData } from 'server/utils/bunker-utils';
import {
    getCommonPageData,
    getMenu,
    getPreparedSections
} from 'server/utils/page-utils';
import getFormattedText, { formatTextsToWiki } from 'server/utils/wiki-utils';

export default async function wasteController(
    req: Request,
    res: Response,
    next: NextFunction
): Promise<void> {
    const pageSection = 'environmental-impact';
    const pageName = 'waste';
    const { bunker, lang } = req;
    const pageData = getBunkerPageData(lang, bunker, pageName);
    const { page } = pageData;

    if (!page.sections) {
        next();

        return;
    }

    const sectionsPrepared = getPreparedSections(page.sections);

    page.sections = sectionsPrepared;
    page.menu = getMenu(sectionsPrepared);

    const { description, items: itemsApproach } = (
        page.sections as unknown as BunkerPageWaste['sections']
    ).approach;
    if (itemsApproach.length > 0) {
        page.sections.approach.items = await formatTextsToWiki(itemsApproach);
    }

    if (description) {
        page.sections.approach.description = await getFormattedText(
            description
        );
    }

    const { items: itemsEngaging } = (
        page.sections as unknown as BunkerPageWaste['sections']
    ).engaging;
    if (itemsEngaging.length > 0) {
        page.sections.engaging.items = await formatTextsToWiki(itemsEngaging);
    }

    const { items: itemsKeeping } = (
        page.sections as unknown as BunkerPageWaste['sections']
    ).keeping;
    if (itemsKeeping.length > 0) {
        page.sections.keeping.items = await formatTextsToWiki(itemsKeeping);
    }

    res.renderBundle('common', pageName, {
        ...getCommonPageData(req, res, pageName, pageSection),
        ...pageData
    });
}
