import { NextFunction, Request, Response } from 'express';

import { getBunkerPageData } from 'server/utils/bunker-utils';
import {
    getCommonPageData,
    getMenu,
    getPreparedSections
} from 'server/utils/page-utils';
import getFormattedText, { formatTextsToWiki } from 'server/utils/wiki-utils';

export default async function anticorruptionController(
    req: Request,
    res: Response,
    next: NextFunction
): Promise<void> {
    const pageSection = 'ethics-integrity';
    const pageName = 'anticorruption';
    const { bunker, lang } = req;
    const pageData = getBunkerPageData(lang, bunker, pageName);
    const { page } = pageData;

    if (!page.sections) {
        next();

        return;
    }

    const sectionsPrepared = getPreparedSections(page.sections);

    page.sections = sectionsPrepared;
    page.menu = getMenu(sectionsPrepared);

    if (page.description) {
        page.description = await getFormattedText(page.description);
    }

    const { items: itemsStatement } = (
        page.sections as unknown as BunkerPageAnticorruption['sections']
    ).statement;
    if (itemsStatement.length > 0) {
        page.sections.statement.items = await formatTextsToWiki(itemsStatement);
    }

    res.renderBundle('common', pageName, {
        ...getCommonPageData(req, res, pageName, pageSection),
        ...pageData
    });
}
