import { NextFunction, Request, Response } from 'express';

import { getBunkerPageData } from 'server/utils/bunker-utils';
import {
    getCommonPageData,
    getMenu,
    getPreparedSections
} from 'server/utils/page-utils';

export default function procurementController(
    req: Request,
    res: Response,
    next: NextFunction
): void {
    const pageSection = 'ethics-integrity';
    const pageName = 'procurement';
    const { bunker, lang } = req;
    const pageData = getBunkerPageData(lang, bunker, pageName);
    const { page } = pageData;

    if (!page.sections) {
        next();

        return;
    }

    const sectionsPrepared = getPreparedSections(page.sections);

    pageData.page.sections = sectionsPrepared;
    pageData.page.menu = getMenu(sectionsPrepared);

    res.renderBundle('common', pageName, {
        ...getCommonPageData(req, res, pageName, pageSection),
        ...pageData
    });
}
