import { NextFunction, Request, Response } from 'express';

import { getBunkerPageData } from 'server/utils/bunker-utils';
import {
    getCommonPageData,
    getMenu,
    getPreparedSections
} from 'server/utils/page-utils';
import { formatTextsToWiki } from 'server/utils/wiki-utils';

export default async function qualityController(
    req: Request,
    res: Response,
    next: NextFunction
): Promise<void> {
    const pageSection = 'ethics-integrity';
    const pageName = 'quality';
    const { bunker, lang } = req;
    const pageData = getBunkerPageData(lang, bunker, pageName);
    const { page } = pageData;

    if (!page.sections) {
        next();

        return;
    }

    const sectionsPrepared = getPreparedSections(page.sections);

    pageData.page.sections = sectionsPrepared;
    pageData.page.menu = getMenu(sectionsPrepared);

    const { items: itemsSearch } = (
        page.sections as unknown as BunkerPageQuality['sections']
    ).search;
    if (itemsSearch.length > 0) {
        page.sections.search.items = await formatTextsToWiki(itemsSearch);
    }

    const { items: itemsAdvertising } = (
        page.sections as unknown as BunkerPageQuality['sections']
    ).advertising;
    if (itemsAdvertising.length > 0) {
        page.sections.advertising.items = await formatTextsToWiki(
            itemsAdvertising
        );
    }

    const { items: itemsBlogging } = (
        page.sections as unknown as BunkerPageQuality['sections']
    ).blogging;
    if (itemsBlogging.length > 0) {
        page.sections.blogging.items = await formatTextsToWiki(itemsBlogging);
    }

    res.renderBundle('common', pageName, {
        ...getCommonPageData(req, res, pageName, pageSection),
        ...pageData
    });
}
