import { NextFunction, Request, Response } from 'express';

import { getBunkerPageData } from 'server/utils/bunker-utils';
import {
    getCommonPageData,
    getMenu,
    getPreparedSections
} from 'server/utils/page-utils';
import getFormattedText, { formatTextsToWiki } from 'server/utils/wiki-utils';

export default async function qualityController(
    req: Request,
    res: Response,
    next: NextFunction
): Promise<void> {
    const pageSection = 'ethics-integrity';
    const pageName = 'security';
    const { bunker, lang } = req;
    const pageData = getBunkerPageData(lang, bunker, pageName);
    const { page } = pageData;

    if (!page.sections) {
        next();

        return;
    }

    const sectionsPrepared = getPreparedSections(page.sections);

    pageData.page.sections = sectionsPrepared;
    pageData.page.menu = getMenu(sectionsPrepared);

    const { description: descriptionBug } = (
        page.sections as unknown as BunkerPageSecurity['sections']
    ).bug;
    page.sections.bug.description = await getFormattedText(descriptionBug);

    const { items: itemsQuestions } = (
        page.sections as unknown as BunkerPageSecurity['sections']
    ).questions;
    if (itemsQuestions.length > 0) {
        page.sections.questions.items = await formatTextsToWiki(itemsQuestions);
    }

    res.renderBundle('common', pageName, {
        ...getCommonPageData(req, res, pageName, pageSection),
        ...pageData
    });
}
