import { NextFunction, Request, Response } from 'express';

import { getBunkerPageData } from 'server/utils/bunker-utils';
import { getCommonPageData } from 'server/utils/page-utils';
import { formatTextsToWiki } from 'server/utils/wiki-utils';

export default async function faqController(
    req: Request,
    res: Response,
    next: NextFunction
): Promise<void> {
    const pageName = 'faq';
    const { bunker, lang } = req;
    const pageData = getBunkerPageData(lang, bunker, pageName);

    const { themes } = pageData.page;
    if (!themes) {
        next();

        return;
    }

    const { items } = themes;
    if (items.length === 0) {
        next();

        return;
    }

    pageData.page.menu = items.map((item: any) => {
        return {
            id: item.id,
            titlenav: item.title
        };
    });

    const formattedItems = items.map(async (item: FaqItem) => {
        const preparedItem = { ...item };

        preparedItem.topics = await formatTextsToWiki(item.topics);

        return preparedItem;
    });

    pageData.page.themes.items = await Promise.all(formattedItems);

    res.renderBundle('common', pageName, {
        ...getCommonPageData(req, res, pageName),
        ...pageData
    });
}
