import { NextFunction, Request, Response } from 'express';

import { getBunkerPageData } from 'server/utils/bunker-utils';
import {
    getCommonPageData,
    getMenu,
    getPreparedSections
} from 'server/utils/page-utils';
import getFormattedText, { formatTextsToWiki } from 'server/utils/wiki-utils';

export default async function educationController(
    req: Request,
    res: Response,
    next: NextFunction
): Promise<void> {
    const pageSection = 'investing-in-people';
    const pageName = 'education';
    const { bunker, lang } = req;
    const pageData = getBunkerPageData(lang, bunker, pageName);
    const { page } = pageData;

    if (!page.sections) {
        next();

        return;
    }

    const sectionsPrepared = getPreparedSections(page.sections);

    page.sections = sectionsPrepared;
    page.menu = getMenu(sectionsPrepared);

    const { items: itemsInitiatives } = (
        page.sections as unknown as BunkerPageEducation['sections']
    ).initiatives;
    if (itemsInitiatives.length > 0) {
        page.sections.initiatives.items = await formatTextsToWiki(
            itemsInitiatives
        );
    }

    const { description } = (
        page.sections as unknown as BunkerPageEducation['sections']
    ).practicum;
    if (description) {
        page.sections.practicum.description = await getFormattedText(
            description
        );
    }

    res.renderBundle('common', pageName, {
        ...getCommonPageData(req, res, pageName, pageSection),
        ...pageData
    });
}
