import { NextFunction, Request, Response } from 'express';

import { getBunkerPageData } from 'server/utils/bunker-utils';
import {
    getCommonPageData,
    getMenu,
    getPreparedSections
} from 'server/utils/page-utils';
import { formatTextsToWiki } from 'server/utils/wiki-utils';

export default async function partnersController(
    req: Request,
    res: Response,
    next: NextFunction
): Promise<void> {
    const pageSection = 'investing-in-people';
    const pageName = 'partners';
    const { bunker, lang } = req;
    const pageData = getBunkerPageData(lang, bunker, pageName);
    const { page } = pageData;

    if (!page.sections) {
        next();

        return;
    }

    const sectionsPrepared = getPreparedSections(page.sections);

    pageData.page.sections = sectionsPrepared;
    pageData.page.menu = getMenu(sectionsPrepared);

    const { items: itemsBenefits } = (
        page.sections as unknown as BunkerPagePartners['sections']
    ).benefits;
    if (itemsBenefits.length > 0) {
        page.sections.benefits.items = await formatTextsToWiki(itemsBenefits);
    }

    const safety = page.sections
        .safety as unknown as BunkerPagePartners['sections']['safety'];
    const { left, right } = safety.items;
    if (left.length > 0) {
        safety.items.left = await formatTextsToWiki(left);
    }
    if (right.length > 0) {
        safety.items.right = await formatTextsToWiki(right);
    }

    res.renderBundle('common', pageName, {
        ...getCommonPageData(req, res, pageName, pageSection),
        ...pageData
    });
}
