import { Request, Response } from 'express';

import { getBunkerPageData } from 'server/utils/bunker-utils';
import { getCommonPageData } from 'server/utils/page-utils';
import getFormattedText from 'server/utils/wiki-utils';

export default async function mainController(
    req: Request,
    res: Response
): Promise<void> {
    const pageName = 'main';
    const { bunker, lang } = req;
    const pageData = getBunkerPageData(lang, bunker, pageName);

    const { description } = pageData.page.governs;
    if (description) {
        pageData.page.governs.description = await getFormattedText(description);
    }

    res.renderBundle('common', pageName, {
        ...getCommonPageData(req, res, pageName),
        ...pageData
    });
}
