import { NextFunction, Request, Response } from 'express';

import { getBunkerPageData } from 'server/utils/bunker-utils';
import {
    getCommonPageData,
    getMenu,
    getPreparedSections
} from 'server/utils/page-utils';
import getFormattedText from 'server/utils/wiki-utils';

export default async function accessibleController(
    req: Request,
    res: Response,
    next: NextFunction
): Promise<void> {
    const pageSection = 'quality-of-life';
    const pageName = 'accessible';
    const { bunker, lang } = req;
    const pageData = getBunkerPageData(lang, bunker, pageName);
    const { page } = pageData;

    if (!page.sections) {
        next();

        return;
    }

    const sectionsPrepared = getPreparedSections(page.sections);

    page.sections = sectionsPrepared;
    page.menu = getMenu(sectionsPrepared);

    const { description: descriptionHand } = (
        page.sections as unknown as BunkerPageAccessible['sections']
    ).hand;
    if (descriptionHand) {
        page.sections.hand.description = await getFormattedText(
            descriptionHand
        );
    }

    const { description: descriptionDyk } = (
        page.sections as unknown as BunkerPageAccessible['sections']
    ).dyk;
    if (descriptionHand) {
        page.sections.dyk.description = await getFormattedText(descriptionDyk);
    }

    res.renderBundle('common', pageName, {
        ...getCommonPageData(req, res, pageName, pageSection),
        ...pageData
    });
}
