import expressBunker from '@yandex-int/express-bunker';
import expressHttpUatraitsMiddleware from '@yandex-int/express-http-uatraits';
import expressSecretkey from '@yandex-int/express-secretkey';
import expressTldMiddleware from '@yandex-int/express-tld';
import expressTvmMiddleware from '@yandex-int/express-tvm';
import expressXForwardedForFix from '@yandex-int/express-x-forwarded-for-fix';
import expressYandexCsp from '@yandex-int/express-yandex-csp';
import expressYandexuid from '@yandex-int/express-yandexuid';
import cfg from '@yandex-int/yandex-cfg';
import cookieParserMiddleware from 'cookie-parser';
import { ErrorRequestHandler, RequestHandler } from 'express';
import helmetMiddleware from 'helmet';

import i18nMiddleware from './i18n';
import finalErrorHandlerMiddleware from './final-error-handler';
import loggerMiddleware from './logger';
import renderMiddleware from './render';

// Loads data from bunker project into req.bunker
export const bunker: RequestHandler = expressBunker(cfg.bunker);

// Parses cookies into req.cookies
export const cookieParser: RequestHandler = cookieParserMiddleware();

// Logs error and sends 500
export const finalErrorHandler: ErrorRequestHandler =
    finalErrorHandlerMiddleware;

// Sets secure headers:
// X-dns-prefetch-control: off
// X-frame-options: SAMEORIGIN
// Strict-transport-security: max-age=15552000; includeSubDomains
// X-download-options: noopen
// X-content-type-options: nosniff
// X-xss-protection: 1; mode=block
export const helmet = helmetMiddleware(cfg.helmet);

// Parses user agent header into req.uatraits
export const httpUatraits: RequestHandler = expressHttpUatraitsMiddleware(
    cfg.httpUatraits
);

export const i18n: RequestHandler = i18nMiddleware();

// Adds logger instance associated with current request into req.logger
export const logger: RequestHandler = loggerMiddleware();

// Adds render function into response object
export const render: RequestHandler | RequestHandler[] = renderMiddleware;

// Generate secret token into req.secretkey and validate it from headers
export const secretkey: RequestHandler = expressSecretkey(cfg.secretkey);

// Parses top level domain into req.tld
export const tld: RequestHandler = expressTldMiddleware();

// Gets TVM service tickets into req.tvmTickets
export const tvm = expressTvmMiddleware(cfg.tvm);

// Filters inccorect IPs from x-forwarded-for header
export const xForwardedForFix = expressXForwardedForFix(cfg.xForwardedForFix);

// Sets Content Security Policy headers and adds nonce into req.nonce
export const yandexCsp = expressYandexCsp(cfg.csp);

// Sets yandexuid cookie
export const yandexuid = expressYandexuid(cfg.yandexuid);
