import { NextFunction, Request, Response } from 'express';

import renderBundle from './render-bundle';

export default (req: Request, res: Response, next: NextFunction): void => {
    res.renderBundle = (bundleName, pageName, data): void => {
        const { lang, url } = req;
        const { html, redirectUrl } = renderBundle({
            bundleName,
            data,
            lang,
            location: url,
            pageName
        });

        if (redirectUrl) {
            res.redirect(redirectUrl);

            return;
        }

        const statusCode = pageName === 'not-found' ? 404 : 200;

        res.status(statusCode).send(html);
    };

    next();
};
