import { Router } from 'express';

import pingHealthcheck from 'server/controllers/healthchecks/ping';
import tvmHealthcheck from 'server/controllers/healthchecks/tvm';

import { logger, tvm } from '../middlewares';

const healthchecksRouter: Router = Router();

healthchecksRouter
    .get('/tvm', [logger, tvm], tvmHealthcheck)
    .get('/ping', logger, pingHealthcheck);

export default function (appRouter: Router): void {
    appRouter.use('/healthchecks', healthchecksRouter);
}
