import _ from 'lodash';
import { stripHtml } from 'string-strip-html';

import { MenuItem, MenuListItem } from 'client/bundles/types';

export function getBunkerCommonData(
    lang: BunkerLang,
    bunker: Bunker,
    pageName?: BunkerPageName,
    pageSection?: BunkerPageSection
): BunkerCommonData {
    const bunkerLangData = _.cloneDeep(_.get(bunker, lang));
    const { sections } = bunkerLangData.common.menu;

    if (pageName) {
        if (['faq', 'download'].includes(pageName)) {
            bunkerLangData.common.links.forEach((link) => {
                if (link.url.includes(pageName)) {
                    // eslint-disable-next-line no-param-reassign
                    link.isCurrent = true;
                }
            });
        } else if (pageName === 'agenda') {
            bunkerLangData.common.agenda.isCurrent = true;
        } else {
            sections.forEach((section: MenuListItem) => {
                if (section.id === pageSection) {
                    // eslint-disable-next-line no-param-reassign
                    section.isCurrent = true;
                }

                section.items.forEach((item: MenuItem) => {
                    if (item.id === pageName) {
                        // eslint-disable-next-line no-param-reassign
                        item.isCurrent = true;
                    }
                });
            });
        }
    }

    return {
        dictionary: bunkerLangData.dictionary,
        common: bunkerLangData.common
    };
}

export function getBunkerPageData(
    lang: BunkerLang,
    bunker: Bunker,
    pageName: BunkerPageName
): PageData {
    const bunkerLangData = _.cloneDeep(_.get(bunker, lang));
    const commonData = _.get(bunkerLangData, 'common');
    const pageData = _.get(bunkerLangData, `pages.${pageName}`);
    const seoData = {
        seo: {
            title: stripHtml(pageData.title || '').result,
            description: stripHtml(commonData.seo.description || '').result,
            ogimage: commonData.seo.ogimage
        }
    };

    return {
        page: Object.assign({}, pageData, seoData)
    };
}
