import { Request, Response } from 'express';
import cfg from '@yandex-int/yandex-cfg';

import { getBunkerCommonData } from 'server/utils/bunker-utils';

export function getBaseUrl(req: Request): string {
    return `${req.protocol}://${req.hostname}${req.path}`;
}

export function getCommonPageData(
    req: Request,
    res: Response,
    pageName: BunkerPageName,
    pageSection?: BunkerPageSection
): BundleData {
    const resHeaders = res.getHeaders();

    const { bunker, ip, nonce, secretkey, uatraits, lang } = req;

    const metrika = {
        metrikaId: cfg.metrikaCounterId,
        metrikaOptions: cfg.metrikaOptions
    };

    return Object.assign(
        {
            ip,
            nonce,
            resHeaders,
            uatraits,
            secretkey,
            pageName,
            lang,
            debug: Boolean(req.query.debug),
            isTestingEnv: ['testing', 'local', 'development'].includes(
                cfg.environment
            ),
            metrika,
            baseUrl: getBaseUrl(req)
        },
        getBunkerCommonData(lang, bunker, pageName, pageSection)
    );
}

export function getPreparedSections(
    sections: Record<string, Record<string, unknown>>
): Record<string, Record<string, unknown>> {
    return Object.keys(sections).reduce((acc, sectionName) => {
        if (!acc[sectionName]) {
            acc[sectionName] = {
                id: sectionName,
                ...sections[sectionName]
            };
        }

        return acc;
    }, {} as Record<string, Record<string, unknown>>);
}

export function getMenu(sections: any): MenuItem[] {
    return Object.values(sections).map((section: any) => {
        return {
            id: section.id,
            titlenav: section.titlenav
        };
    });
}
